
package Alkindi.Services.ServicesImpl;

import oracle.jdbc.driver.*;
import java.sql.*;
import java.math.*;
import Alkindi.Data.*;
import Alkindi.Services.*;
import Alkindi.Services.Util.*;
import Alkindi.Services.InternalData.*;

/* 
$Header: SearchManager.java, 23, 4/26/01 2:37:17 PM, Schwartz, Joe$
$Log: 
 23   Alkindi Development1.22        4/26/01 2:37:17 PM   Schwartz, Joe  
      Modifed to account for new InternalData package.
 22   Alkindi Development1.21        4/26/01 1:11:15 PM   Schwartz, Joe   Moved
      into new ServicesImpl package.
 21   Alkindi Development1.20        3/14/01 5:50:44 PM   Schwartz, Joe   Made
      the rest of these implementation classes abstract.
 20   Alkindi Development1.19        2/13/01 5:55:31 PM   Schwartz, Joe  
      Changed to account for new Product id int type and SparseRatingsArray.
 19   Alkindi Development1.18        2/5/01 3:08:23 PM    Schwartz, Joe  
      Changed to accomodate new AlkConn members.
 18   Alkindi Development1.17        1/25/01 9:58:07 PM   Schwartz, Joe  
      Working on speed, sensibility.
 17   Alkindi Development1.16        12/28/00 2:56:58 PM  Schwartz, Joe  
      Standardized methods to use final parameters and fully-qualified types
      where necessary. Makes Rose happy.
 16   Alkindi Development1.15        12/28/00 1:47:11 PM  Schwartz, Joe  
      Replaced missing methods and other errors due to Rose import. 
 15   Alkindi Development1.14        12/28/00 1:11:11 PM  Schwartz, Joe   Added
      Version Control header info.
      Synchronized with ISearchManager interface.
 14   Alkindi Development1.13        12/26/00 6:57:16 PM  Schwartz, Joe   
 13   Alkindi Development1.12        12/26/00 5:37:00 PM  Schwartz, Joe   
 12   Alkindi Development1.11        12/6/00 7:11:59 PM   Schwartz, Joe   Added
      catch blocks for generic exceptions and finally blocks to close all
      database connections.
 11   Alkindi Development1.10        12/4/00 3:22:03 PM   Schwartz, Joe   Put
      limit of 100 results in searchMovies(). This is temporary, as the API will
      change to include the max. number of results to return as an argument.
 10   Alkindi Development1.9         11/29/00 1:32:46 PM  Schwartz, Joe  
      Removed addional '%' characters sandwiching search terms.
 9    Alkindi Development1.8         11/20/00 10:52:35 PM Schwartz, Joe   
 8    Alkindi Development1.7         11/6/00 7:06:00 PM   Schwartz, Joe   
 7    Alkindi Development1.6         10/22/00 10:38:46 AM Schwartz, Joe  
      AppianDelivery 10.20.00
 6    Alkindi Development1.5         10/20/00 12:00:44 PM Schwartz, Joe   
 5    Alkindi Development1.4         10/17/00 2:22:57 PM  Schwartz, Joe  
      Delivery 10.16.00
 4    Alkindi Development1.3         10/7/00 4:34:33 PM   Schwartz, Joe   
 3    Alkindi Development1.2         10/7/00 4:30:55 PM   Schwartz, Joe   
 2    Alkindi Development1.1         10/7/00 4:26:01 PM   Schwartz, Joe   Files
      as delivered to Alkindi Oct. 5, 2000.
 1    Alkindi Development1.0         9/26/00 4:13:29 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 */
public abstract class SearchManager implements ISearchManager 
{
	final String cName = "SearchManager";
	LogManager logger = null;
	
	/**
	 * @roseuid 3A4B6612008C
	 */
	public Alkindi.Data.SystemUserList findMember(java.lang.String query) throws AlkExcept 
	{
		String errmsg = "";
		final String mName = "findMember";
		Connection con = null;

		SystemUserList sul = new SystemUserList();

        try {
			
			con = AlkConn.getConnection();
            CallableStatement cs  = con.prepareCall(
                "{ call pkg_ALKINDI_SEARCH.sp_SEL_UserID_By_Screenname(?,?,?)}");

            cs.setString(1, "%" + query + "%");
            cs.registerOutParameter(2, OracleTypes.CURSOR);
            cs.registerOutParameter(3, Types.INTEGER);
            cs.executeQuery();

            int       error = cs.getInt(3);
            ResultSet rs    = ((OracleCallableStatement) cs).getCursor(2);

            while (rs.next()) {
                sul.add(new SystemUser(rs.getInt("USER_ID")));
            }

            rs.close();
            cs.close();

            if (error != 0) {
				errmsg ="Stored Procedure Error at sp_SEL_UserID_By_Screenname"; 
				logger.err(cName, mName, errmsg);
                throw new AlkExcept(errmsg, error);
            }
        }    //END try
                
		catch (SQLException se) {
			errmsg = "SQL Exception: " + se.getMessage();
			logger.err(cName, mName, errmsg);
			throw new AlkExcept(errmsg + " in " + mName, 6004);
        }
		catch(AlkExcept ae) {
			throw (AlkExcept)ae.fillInStackTrace();
		}
		catch (Exception e) {
			errmsg = "Unexpected error: " + e.getMessage();
			logger.err(cName, mName, errmsg);
			throw new AlkExcept(errmsg + " in " + mName, 2603);
		}
		finally {
			try { con.close(); } catch(Exception e) {}
		}
        return sul;
	}
	
	/**
	 * @roseuid 3A4B6612006F
	 */
	public Alkindi.Data.ProductList findProduct(final java.lang.String mfield, final java.lang.String msearch) throws AlkExcept 
	{
		final String mName = "findProduct";
		String errmsg = "";
		Connection con = null;

        ProductList pl = new ProductList();

        try {
			
			con = AlkConn.getConnection();
            CallableStatement cs  = con.prepareCall(
                "{ call pkg_ALKINDI_SEARCH.sp_SEL_Movie_Simple(?,?,?,?)}");
			
			cs.setString(1, "%" + mfield + "%");	
			cs.setString(2, "%" + msearch + "%");
            		cs.registerOutParameter(3, OracleTypes.CURSOR);
			cs.registerOutParameter(4, Types.INTEGER);
			cs.execute();

			int       error = cs.getInt(4);
			if (error != 0) {
				errmsg = "Stored Procedure Error at sp_SEL_Movie_Simple";
				logger.err(cName, mName, errmsg);
                throw new AlkExcept(errmsg , error);
			}
			ResultSet rs    = ((OracleCallableStatement) cs).getCursor(3);

            while (rs.next()) {
		// This hardcodes a product type of 1
		//
                pl.add(new Product (1, rs.getInt(AlkConn.COL_PID)));
            }
	
            rs.close();
            cs.close();

        }    
                
		catch (SQLException se) {
			errmsg = "SQL Exception: " + se.getMessage();
			logger.err(cName, mName, errmsg);
			throw new AlkExcept(errmsg + " in " + mName, 6004);
        }
		catch(AlkExcept ae) {
			throw (AlkExcept)ae.fillInStackTrace();
		}
		catch (Exception e) {
			errmsg = "Unexpected error: " + e.getMessage();
			logger.err(cName, mName, errmsg);
			throw new AlkExcept(errmsg + " in " + mName, 2602);
		}
		finally {
			try { con.close(); } catch(Exception e) {}
		}

	return pl;
	}
	
	/**
	 * @roseuid 3A4B6612005D
	 */
	public void initLogging() 
	{
		if (logger == null) 
			logger = new LogManager();
	}
	
	/**
	 * @roseuid 3A4B6612006D
	 */
	public Alkindi.Data.ProductList searchMovie(final Alkindi.Data.MovieSearch ms) throws AlkExcept 
	{
		final String mName="searchMovie";
		String errmsg = "";
		Connection con = null;
		
		
		//	Eventually this will move to the function arguments.
		//
		final int MAX_RESULTS_TO_RETURN = 100;
        ProductList pl = new ProductList();

        try {
			
			con = AlkConn.getConnection();
            CallableStatement cs  = con.prepareCall(
                "{ call pkg_ALKINDI_SEARCH.sp_SEL_Movie_Advance(?,?,?,?,?,?)}");
			
			logger.dbgLog(cName, mName, "Searching for title=" + ms.title + " actor=" + ms.actor + " director=" + ms.director + " desc=" + ms.description);
			cs.setString(1, ms.title);
			cs.setString(2, ms.description);
			cs.setString(3, ms.actor);
			cs.setString(4, ms.director);
            cs.registerOutParameter(5, OracleTypes.CURSOR);
            cs.registerOutParameter(6, Types.INTEGER);
            cs.executeQuery();

            int       error = cs.getInt(6);
            ResultSet rs    = ((OracleCallableStatement) cs).getCursor(5);

            while (rs.next() && rs.getRow() < MAX_RESULTS_TO_RETURN) {
                pl.add(new Product (1, rs.getInt(AlkConn.COL_PID))); // HARDCODED as Movie Type
            }
	
            rs.close();
            cs.close();

            if (error == 6567) {
				String errMsg = "Stored Procedure Error at sp_SEL_Movie_Advance";
				logger.err(cName, mName, errMsg);
                throw new AlkExcept(errMsg ,6567);
            }
        }    
                
		catch (SQLException se) {
			errmsg = "SQL Exception: " + se.getMessage();
			logger.err(cName, mName, errmsg);
			throw new AlkExcept(errmsg + " in " + mName, 6004);
        }
		catch (Exception e) {
			errmsg = "Unexpected error: " + e.getMessage();
			logger.err(cName, mName, errmsg);
			throw new AlkExcept(errmsg + " in " + mName, 2601);
		}
		finally {
			try { con.close(); } catch(Exception e) {}
		}
		return pl;
	}
}
